///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _CLASSPACKET_CPP
#define _CLASSPACKET_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0500

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CSockSrvr::MakeClassPacket(char *outBuffer, const char *inBuffer, int inLength)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::MakeClassPacket.\n");
    #endif

    int RPos = 0;
    int WPos = 0;

    int PacketHeader = PACKETHEADER;

    while(RPos < sizeof(int))
        outBuffer[WPos++] = ((char *)&PacketHeader)[RPos++];

    RPos = 0;

    while(RPos < sizeof(int))
        outBuffer[WPos++] = ((char *)&inLength)[RPos++];

    RPos = 0;

    while(RPos < inLength)
        outBuffer[WPos++] = inBuffer[RPos++];

	return WPos; // The total length of the packet
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	GetPartialPacketDifference
	Return Values:
		  -1: No data, no parital packet, or error.
		  >0: Amount of data missing from the partial packet.
*/
int CSockSrvr::GetPartialPacketDifference(int iClient)
{
	#ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::GetPartialPacketDifference.\n");
    #endif

    int RPos = 0;
    int WPos = 0;

    int PacketHeader = 0;
    int DataLen = 0;

    while(WPos < sizeof(int))
        ((char *)&PacketHeader)[WPos++] = scRecvBuf[iClient][RPos++];

	if(PacketHeader != PACKETHEADER)
        return -1;

    WPos = 0;

    while(WPos < sizeof(int))
        ((char *)&DataLen)[WPos++] = scRecvBuf[iClient][RPos++];

    //If the data chunk is less than Zero bytes or greader than icHardRecvBufSz, the packet must be rejected.
	if((DataLen + RPos) > icHardRecvBufSz || DataLen < 0)
        return -1;

	//if((RPos+DataLen) > icRecvBufSz[iClient])
	if((DataLen + RPos) > icRecvBufSz[iClient])
	{
		return ((RPos + DataLen) - icRecvBufSz[iClient]);
	}

	return -1;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	BreakClassPacket
	Return Values:
		0: No error, we got data.
		1: Error, Invalid packet header.
		2: Error, Bad data.
		3: No Error, Last data in packet.
		4: No Error, Partial packet, waiting on rest of data.
*/
int CSockSrvr::BreakClassPacket(int iClient, char *outBuf, int *iOutBufSz)
{
	#ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::BreakClassPacket.\n");
    #endif

    int RPos = 0;
    int WPos = 0;

    int PacketHeader = 0;
    int DataLen = 0;

    while(WPos < sizeof(int))
        ((char *)&PacketHeader)[WPos++] = scRecvBuf[iClient][RPos++];

	if(PacketHeader != PACKETHEADER)
        return 1;

    WPos = 0;

    while(WPos < sizeof(int))
        ((char *)&DataLen)[WPos++] = scRecvBuf[iClient][RPos++];

    //If the data chunk is less than Zero bytes or greader than icHardRecvBufSz, the packet must be rejected.
	if((DataLen + RPos) > icHardRecvBufSz || DataLen < 0)
        return 2;

	if((DataLen + RPos) > icRecvBufSz[iClient])
	{
		//The receive buffer currently contains a partial packet.
		//More data will have to be received before this data can be processed.
		return 4;
	}
	
	WPos = 0;

    while(WPos < DataLen && RPos < icRecvBufSz[iClient])
        outBuf[WPos++] = scRecvBuf[iClient][RPos++];

	*iOutBufSz = DataLen;

	int iNewRecvBufSz =  icRecvBufSz[iClient] - RPos;

   	WPos = 0;
	while(RPos < icRecvBufSz[iClient])
		scRecvBuf[iClient][WPos++] = scRecvBuf[iClient][RPos++];

	icRecvBufSz[iClient] = iNewRecvBufSz;

	if(icRecvBufSz[iClient] == 0)
	{
		return 3;
	}

	return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
